/* ILTP */
(function($) {
    $(document).ready(function() {
        $('.internal-link-tooltip-preview').tooltipster({
            contentAsHTML: true,
            delay: 300,
            theme: 'tooltipster-letswp',
            minWidth: 250,
            animationDuration: 200,
            functionBefore: createCard,
            functionReady: calculateColorGlow
        });
    });
    function createCard(instance, helper) {
        if (window.innerWidth <= 1024) {
            return false;
        }
        var title = helper.origin.dataset.postTitle;
        var ex = helper.origin.dataset.postExcerpt;
        var src = helper.origin.dataset.postImageSrc;
        var w = helper.origin.dataset.postImageW;
        var h = helper.origin.dataset.postImageH;
        var html = '<div class="iltp-card" style="max-width:' + w + 'px">';
        html +=
            '<img src="' + src + '" width="' + w + '" height="' + h + '" crossorigin="anonymous" class="iltp-image" />';
        html += '<div class="iltp-title">' + title + '</div>';
        html += '<div class="iltp-excerpt">' + ex + '</div>';
        html += '</div>';
        instance.content(html);
    }
    function calculateColorGlow(instance, helper) {
        var colorThief = new ColorThief();
        var tt = instance.elementTooltip();
        var img = tt.querySelector('img');
        var box = tt.querySelector('.tooltipster-box');

        // Make sure image is finished loading
        if (img.complete) {
            var RGB = colorThief.getColor(img);
            makeItGlow(tt, box, RGB, instance.__lastPosition.side);
        } else {
            img.addEventListener('load', function() {
                var RGB = colorThief.getColor(img);
                makeItGlow(tt, box, RGB, instance.__lastPosition.side);
            });
        }
    }
    function makeItGlow(tt, box, RGB, side) {
        var cssRGB = 'rgb(' + RGB[0] + ', ' + RGB[1] + ', ' + RGB[2] + ')';
        //box.style.boxShadow = '6px 6px 20px -10px ' + cssRGB;
        box.style.backgroundColor = cssRGB;
        tt.querySelector('.tooltipster-arrow-border').style['border' + capitalizeFirstLetter(side) + 'Color'] = cssRGB;
        tt.classList.add('tooltipster-' + lightOrDark(RGB[0], RGB[1], RGB[2]) + '-bg');
        tt.querySelector('.iltp-image').style.opacity = 1;
    }

    // https://awik.io/determine-color-bright-dark-using-javascript/
    function lightOrDark(r, g, b) {
        // Variables for red, green, blue values
        var hsp;

        // HSP (Highly Sensitive Poo) equation from http://alienryderflex.com/hsp.html
        hsp = Math.sqrt(0.299 * (r * r) + 0.587 * (g * g) + 0.114 * (b * b));

        // Using the HSP value, determine whether the color is light or dark
        if (hsp > 150) {
            return 'light';
        } else {
            return 'dark';
        }
    }
    function capitalizeFirstLetter(string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    }
})(jQuery);
