<?php
/*
Plugin Name: Let's WP - WPML String Shortcode Test
Description: Test plugin for translating text inputs with WPML [wpml-string] shortcode.
Author: Let's WP
Author URI:  https://letwp.io
*/

/**
 * Register admin menu page for testing
 */
function lwp_wpml_string_sc_test__admin_add_page() {

    add_options_page(
        'Let\'s WP - WPML String Shortcode Test',
        'Let\'s WP - WPML String Shortcode Test',
        'manage_options',
        'lwp-wmpl-string-sc-test',
        'lwp_wpml_string_sc_test__page'
    );
}

add_action( 'admin_menu', 'lwp_wpml_string_sc_test__admin_add_page' );

/**
 * Settings page
 */
function lwp_wpml_string_sc_test__page() {
    ?>
    <div class="wrap">
        <h2>Settings for WPML String Shortcode Test</h2>
        <form method="post" action="options.php">
            <?php
            settings_fields( 'section' );
            do_settings_sections( 'lwp-wmpl-string-sc-test' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

/**
 * Display input field for "last Updated on" text
 */
function lwp_wpml_string_sc_test__display_lu_field() {
    printf(
        '<input type="text" name="lwp_wpml_lu_text" id="lwp_wpml_lu_text" class="regular-text code" value="%s">',
        esc_attr( get_option( 'lwp_wpml_lu_text' ) )
    );
}

/**
 * Register sections and settings
 */
function lwp_wpml_string_sc_test__register_settings() {

    add_settings_section(
        'section',
        'Settings',
        null,
        'lwp-wmpl-string-sc-test'
    );

    register_setting(
        'section',
        'lwp_wpml_lu_text'
    );

    add_settings_field(
        'lwp_wpml_lu_text',
        '"Last Updated on" Text',
        'lwp_wpml_string_sc_test__display_lu_field',
        'lwp-wmpl-string-sc-test',
        'section'
    );
}

add_action( 'admin_init', 'lwp_wpml_string_sc_test__register_settings' );

/**
 * Append Last Updated info to the content
 *
 * @param $content $content Content
 * @return string $content  Content
 */
function lwp_wpml_string_sc_test__content( $content ) {

    $written_by = get_option( 'lwp_wpml_lu_text', '' );
    global $post;
    if ( !is_singular( 'post' ) || !is_main_query() || is_admin() ) return $content;

    if ( strlen( $written_by ) ) {

        $content = sprintf(
            '%s<div>%s: %s</div>',
            $content,
            $written_by,
            get_the_modified_time( 'M d, Y' )
        );
    }

    return $content;

}

add_filter( 'the_content', 'lwp_wpml_string_sc_test__content' );

/**
 * Plugin activation hook
 */
function wp_wpml_sc_test__activation() {
    $db_data = get_option( 'lwp_wpml_lu_text', false );
    if ( $db_data === false ) update_option( 'lwp_wpml_lu_text', 'Last Updated on' );
    update_option( 'foo', 'Last Updated on1' );
}

register_activation_hook( __FILE__, 'wp_wpml_sc_test__activation' );

/**
 * Plugin uninstall hook
 */
function wp_wpml_sc_test__uninstall() {

    delete_option( 'lwp_wpml_lu_text' );
}

register_uninstall_hook( __FILE__, 'wp_wpml_sc_test__uninstall' );